/*
 * Handle client alert requests
 */
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "libfma.h"
#include "lf_fms_comm.h"
#include "lf_channel.h"
#include "lf_alert.h"

#include "fms.h"
#include "fms_error.h"
#include "fms_alert.h"
#include "fms_client.h"

/*
 * Helper that counts alerts
 */
int
fms_alert_count(
  int show_acked,
  int show_relics)
{
  struct fms_alert_vars *av;
  struct fms_alert *anchor;
  struct fms_alert *ap;
  int num_alerts;

  /* get pointers to alert structs */
  av = F.alert_vars;
  anchor = av->alerts_anchor;

  ap = anchor->main_next;
  num_alerts = 0;
  while (ap != anchor) {
    struct lf_alert *lap;

    lap = &ap->alert;
    if ((!lap->acked || show_acked)
	&& (!lap->relic || show_relics)) {
      ++num_alerts;
    }

    ap = ap->main_next;
  }

  return num_alerts;
}

/*
 * Handle a query of alerts
 */
int
fms_client_query_alerts(
  struct fms_client_desc *cdp)
{
  struct fms_alert_vars *av;
  struct fms_alert *anchor;
  struct fms_alert *ap;
  struct fms_query_alerts *msg;
  int num_alerts;
  uint32_t val;
  int rc;

  /* get pointers to alert structs */
  av = F.alert_vars;
  anchor = av->alerts_anchor;

  /* get a pointer to the query message */
  msg = &(cdp->cl_msgbuf->query_alerts);

  /* first, count the number of alerts we will return */
  num_alerts = fms_alert_count(msg->show_acked, msg->show_relics);

  /* send number of alerts */
  val = htonl(num_alerts);
  rc = send(cdp->chp->fd, &val, sizeof(val), 0);
  if (rc != sizeof(val)) LF_ERROR(("Sending alert count to client"));

  /* send each alert */
  ap = anchor->main_next;
  while (ap != anchor) {
    struct lf_alert alert;

    /* get raw alert struct */
    alert = ap->alert;

    lf_alert_hton(&alert);		/* byteswap for sending */

    if ((!alert.acked || msg->show_acked)
	&& (!alert.relic || msg->show_relics)) {

      if (--num_alerts < 0) LF_ERROR(("Alert underflow!"));

      rc = send(cdp->chp->fd, &alert, sizeof(alert), 0);
      if (rc != sizeof(alert)) LF_ERROR(("Error sending alert body"));
    }

    ap = ap->main_next;
  }

  if (num_alerts != 0) LF_ERROR(("Number of alerts changed while sending!"));
  return 0;

 except:
  return -1;
}

/*
 * Query an alert
 */
int
fms_client_ack_alert(
  struct fms_client_desc *cdp)
{
  int rc;
  uint32_t id;

  /* byteswap the ID */
  id = ntohl(cdp->cl_msgbuf->ack_alert.alert_id_32);

  rc = fms_ack_alert(id);
  if (rc == -1) return -1;

  return 0;
}
